# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.manager


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Announcement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(max_length=100, verbose_name='announcement_filed_subject')),
                ('content', models.TextField(verbose_name='announcement_filed_content')),
                ('category', models.SmallIntegerField(choices=[(1, 'announcement_category_public'), (2, 'announcement_category_private')], verbose_name='announcement_field_category')),
                ('sender', models.CharField(blank=True, max_length=50, null=True, verbose_name='announcement_field_sender')),
                ('system_sender', models.CharField(blank=True, max_length=50, null=True, verbose_name='announcement_field_systemSender')),
                ('create_time', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='announcement_field_noticeTime')),
            ],
            options={
                'verbose_name': 'app_model_announcement',
                'verbose_name_plural': 'app_model_announcement',
                'default_permissions': ('delete',),
            },
        ),
        migrations.CreateModel(
            name='AppActionLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.CharField(max_length=20, verbose_name='actionLog_field_user')),
                ('client', models.CharField(blank=True, max_length=50, null=True, verbose_name='actionLog_field_client')),
                ('action', models.CharField(blank=True, max_length=50, null=True, verbose_name='actionLog_field_action')),
                ('params', models.TextField(blank=True, null=True, verbose_name='actionLog_field_params')),
                ('describe', models.TextField(blank=True, null=True, verbose_name='actionLog_field_describe')),
                ('request_status', models.SmallIntegerField(choices=[(0, 'appActionLog_status_exception'), (1, 'appActionLog_status_successful')], verbose_name='actionLog_field_status')),
                ('action_time', models.DateTimeField(verbose_name='actionLog_field_actionTime')),
                ('remote_ip', models.CharField(blank=True, max_length=20, null=True, verbose_name='actionLog_field_remoteIp')),
            ],
            options={
                'verbose_name': 'app_model_actionLog',
                'default_permissions': ('delete',),
            },
        ),
        migrations.CreateModel(
            name='AppList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=50, verbose_name='appList_field_userName')),
                ('login_time', models.DateTimeField(editable=False, verbose_name='appList_field_loginTime')),
                ('last_active', models.DateTimeField(editable=False, verbose_name='appList_field_lastActive')),
                ('token', models.CharField(editable=False, max_length=100, verbose_name='appList_field_token')),
                ('device_token', models.TextField(editable=False, max_length=100, verbose_name='appList_field_deviceToken')),
                ('client_id', models.CharField(editable=False, max_length=100, verbose_name='appList_field_clientId')),
                ('client_category', models.SmallIntegerField(choices=[(1, 'appOS_option_ios'), (2, 'appOS_option_android')], editable=False, verbose_name='appList_field_clientCategory')),
                ('active', models.SmallIntegerField(blank=True, choices=[(1, 'activeStatus_option_active'), (0, 'activeStatus_option_inactive')], default=1, null=True, verbose_name='appList_field_runStatus')),
                ('enable', models.SmallIntegerField(blank=True, choices=[(1, 'enableStatus_option_enable'), (0, 'enableStatus_option_disable')], default=1, null=True, verbose_name='appList_field_accessStatus')),
            ],
            options={
                'verbose_name': 'app_model_appList',
                'verbose_name_plural': 'app_model_appList',
                'default_permissions': ('delete',),
            },
        ),
        migrations.CreateModel(
            name='AppNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sender', models.CharField(blank=True, max_length=50, null=True, verbose_name='appNotice_field_sender')),
                ('system_sender', models.CharField(blank=True, max_length=50, null=True, verbose_name='appNotice_field_systemSender')),
                ('category', models.SmallIntegerField(choices=[(1, 'notification_category_leave'), (2, 'notification_category_overtime'), (3, 'notification_category_manualLog'), (4, 'notification_category_training'), (5, 'notification_category_schedule'), (6, 'notification_category_announcement'), (7, 'notification_category_exception')], verbose_name='appNotice_field_category')),
                ('sub_category', models.IntegerField(blank=True, choices=[(61, 'notification_subCategory_publicAnnouncement'), (62, 'notification_subCategory_privateAnnouncement'), (71, 'notification_subCategory_late'), (72, 'notification_subCategory_earlyLeave'), (73, 'notification_subCategory_absent')], null=True, verbose_name='appNotice_field_subCategory')),
                ('content', models.TextField(blank=True, null=True, verbose_name='appNotice_field_content')),
                ('source', models.IntegerField(blank=True, null=True, verbose_name='appNotice_field_source')),
                ('notification_time', models.DateTimeField(verbose_name='appNotice_field_sendTime')),
                ('read_status', models.SmallIntegerField(choices=[(0, 'notification_readStatus_unread'), (1, 'notification_readStatus_read')], default=0, verbose_name='appNotice_field_readStatus')),
                ('read_time', models.DateTimeField(blank=True, null=True, verbose_name='appNotice_field_readTime')),
            ],
            options={
                'verbose_name': 'app_model_notification',
                'verbose_name_plural': 'app_model_notification',
                'default_permissions': ('delete',),
            },
        ),
        migrations.CreateModel(
            name='GPSForDepartment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('location', models.CharField(max_length=100, verbose_name='gpsForDepartment_field_location')),
                ('longitude', models.FloatField(validators=[django.core.validators.MinValueValidator(-180.0), django.core.validators.MaxValueValidator(180.0)], verbose_name='gpsForDepartment_field_longitude')),
                ('latitude', models.FloatField(validators=[django.core.validators.MinValueValidator(-90.0), django.core.validators.MaxValueValidator(90.0)], verbose_name='gpsForDepartment_field_latitude')),
                ('distance', models.IntegerField(default=50, help_text='gpsForDepartment_field_distanceHelpTxt', verbose_name='gpsForDepartment_field_distance')),
                ('start_date', models.DateField(verbose_name='gpsForDepartment_field_startDate')),
                ('end_date', models.DateField(verbose_name='gpsForDepartment_field_endDate')),
            ],
            options={
                'verbose_name': 'mobile_model_gpsForDepartment',
                'verbose_name_plural': 'mobile_model_gpsForDepartment',
                'default_permissions': ('delete', 'change', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='GPSForEmployee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('location', models.CharField(max_length=100, verbose_name='gpsForEmployee_field_location')),
                ('longitude', models.FloatField(validators=[django.core.validators.MinValueValidator(-180.0), django.core.validators.MaxValueValidator(180.0)], verbose_name='gpsForEmployee_field_longitude')),
                ('latitude', models.FloatField(validators=[django.core.validators.MinValueValidator(-90.0), django.core.validators.MaxValueValidator(90.0)], verbose_name='gpsForEmployee_field_latitude')),
                ('distance', models.IntegerField(default=50, help_text='gpsForEmployee_field_distanceHelpTxt', verbose_name='gpsForEmployee_field_distance')),
                ('start_date', models.DateField(verbose_name='gpsForEmployee_field_startDate')),
                ('end_date', models.DateField(verbose_name='gpsForEmployee_field_endDate')),
            ],
            options={
                'verbose_name': 'mobile_model_gpsForEmployee',
                'verbose_name_plural': 'mobile_model_gpsForEmployee',
                'default_permissions': ('delete', 'change', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
    ]
